// eventctrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "eventctr.h"
#include "eventctrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEventctrDlg dialog

CEventctrDlg::CEventctrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEventctrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEventctrDlg)
	m_ctvalue = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CEventctrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEventctrDlg)
	DDX_Text(pDX, IDC_EDIT1, m_ctvalue);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEventctrDlg, CDialog)
	//{{AFX_MSG_MAP(CEventctrDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEventctrDlg message handlers

BOOL CEventctrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// open the driver; pass in driver name to avoid the OpenDriver dialog
	// could use the desktop window handle if making a console app
	m_driverInstance=OpenDriverLINX(m_hWnd,"kmbctm");
	// allocate the SR structure and init all members to zero
	m_pSR=(DL_ServiceRequest*)new DL_ServiceRequest;
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	// initialize the board belonging to the opened driver
	m_pSR->operation=INITIALIZE;
	m_pSR->device=0;   // device number must agree with one assigned in DLinx Config Panel
	m_pSR->mode=OTHER;
	m_pSR->subsystem=DEVICE;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEventctrDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEventctrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEventctrDlg::showMessage(DL_ServiceRequest *SR)
{
	if(SR->result != NoErr)
	{
		SR->operation=MESSAGEBOX;
		DriverLINX(SR);
	}
}

void CEventctrDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	CloseDriverLINX(m_driverInstance);
	m_driverInstance=NULL;
	delete m_pSR;
	m_pSR=NULL;
	OnOK();
	
}

void CEventctrDlg::OnStart() 
{
	// set up the SR for a COUNT mode task
	m_pSR->operation=START;
	m_pSR->subsystem=CT;
	m_pSR->mode=POLLED;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->timing.typeEvent=RATEEVENT;
	m_pSR->timing.u.rateEvent.channel=0; // use channel 0 for this task
	m_pSR->timing.u.rateEvent.mode=COUNT;
	m_pSR->timing.u.rateEvent.clock=EXTERNAL; // feed a signal into the counter
	m_pSR->timing.u.rateEvent.gate=NOCONNECT;
	m_pSR->timing.u.rateEvent.period=0; /*The period and onCount fields should be 0 for
										event counting*/
	m_pSR->timing.u.rateEvent.onCount=0;
	m_pSR->timing.u.rateEvent.pulses=0; /* a 1 here would mean that the counter will
										not roll over at 65535 and keep going*/
	DriverLINX(m_pSR);
	showMessage(m_pSR);

	GetDlgItem(IDC_READ)->EnableWindow(TRUE);

			/*
    This application was tested with a CTM-05/A in Win98SE using
	CTM-850A01.0.0.2 version of DriverLINX
	*/


}

void CEventctrDlg::OnRead() 
{
	// TODO: Add your control notification handler code here

	m_pSR->operation=STATUS;
	m_pSR->status.typeStatus=TIMERSTATUS;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	m_ctvalue.Format("%d",m_pSR->status.u.timerStatus.count);
	UpdateData(FALSE);


	
}

void CEventctrDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	m_pSR->operation=STOP;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	
}
